// source --> https://wp.raymoon.com.sa/wp-content/plugins/live-news-lite/public/assets/js/dev/main.js?ver=1.09 
jQuery( document ).ready(
	function ($) {

		let daextlnl_archived_ticker_data = '';
		let daextlnl_ticker_cycles        = 0;

		/**
		 * Append the ticker in the DOM if the daextlnl_apply_ticker flag is defined.
		 */
		if ( typeof daextlnl_apply_ticker != 'undefined' && daextlnl_apply_ticker ) {

			// Append the ticker before the ending body tag.
			daextlnl_append_html();

			// Refresh the news only if the news ticker is in "open" status.
			if ( "block" === ( $( "#daextlnl-container" ).css( "display" ) ) ) {

				// Refresh the news.
				daextlnl_refresh_news();

			}

			/**
			 * If the clock is based on the user time and the clock_autoupdate option enabled set the interval used to
			 * update the clock.
			 */
			if (daextlnl_clock_source === 2 && daextlnl_clock_autoupdate === 1) {
				window.setInterval( daextlnl_set_clock_based_on_user_time, (daextlnl_clock_autoupdate_time * 1000) );
			}

		}

		/**
		 * This function is used to refresh all the data displayed in the ticker and to animate the sliding news from
		 * the initial to the final destination. It's called in the following situations:
		 *
		 * - When the document is ready
		 * - When a cycle of sliding news has finished its animation
		 * - When the news ticker is opened with the open button
		 */
		function daextlnl_refresh_news(){

			if (typeof daextlnl_ticker_transient != 'undefined' && daextlnl_ticker_transient !== null) {

				// Convert the string to a JSON object.
				try {
					daextlnl_archived_ticker_data = JSON.parse( daextlnl_ticker_transient );
				} catch (error) {
					daextlnl_archived_ticker_data = false;
				}

				// Set the transient to null so it won't be used multiple times.
				daextlnl_ticker_transient = null;

			}

			if ( daextlnl_archived_ticker_data === '' || daextlnl_archived_ticker_data === false || daextlnl_ticker_cycles >= daextlnl_cached_cycles ) {

				// Retrieve the news with ajax and refresh the news ---------------------------------------------------.

				daextlnl_ticker_cycles = 0;

				// Set ajax in synchronous mode.
				jQuery.ajaxSetup( {async:false} );

				// Prepare input for the ajax request.
				const data = {
					"action": "get_ticker_data",
					"security": window.DAEXTLNL_PARAMETERS.nonce,
					"ticker_id": daextlnl_ticker_id
				};

				// Ajax.
				$.post(
					window.DAEXTLNL_PARAMETERS.ajaxUrl,
					data,
					function (ticker_data) {

						daextlnl_archived_ticker_data = ticker_data;

						try {
							ticker_data = JSON.parse( ticker_data );
						} catch (error) {
							ticker_data = false;
						}

						daextlnl_update_the_clock( ticker_data );

						daextlnl_refresh_featured_news( ticker_data );

						daextlnl_refresh_sliding_news( ticker_data );

						daextlnl_slide_the_news();

					}
				);

				// Set ajax in asynchronous mode.
				jQuery.ajaxSetup( {async:true} );

			} else {

				// Use the current ticker data to refresh the news ----------------------------------------------------.

				daextlnl_ticker_cycles++;

				try {
					ticker_data = JSON.parse( daextlnl_archived_ticker_data );
				} catch (error) {
					ticker_data = false;
				}

				daextlnl_update_the_clock( ticker_data );

				daextlnl_refresh_featured_news( ticker_data );

				daextlnl_refresh_sliding_news( ticker_data );

				daextlnl_slide_the_news();

			}

		}

		/**
		 * Update the clock.
		 *
		 * @param ticker_data
		 */
		function daextlnl_update_the_clock(ticker_data){

			if (daextlnl_clock_source == 2) {

				// Update the clock based on the user time ------------------------------------------------------------.
				daextlnl_set_clock_based_on_user_time();

			} else {

				// Update the clock based on the server time ----------------------------------------------------------.
				const timestamp = moment.unix( ticker_data.time ).utc();
				$( "#daextlnl-clock" ).text( timestamp.format( daextlnl_clock_format ) );

			}

		}

		/**
		 * Remove the featured news title and excerpt from the DOM and uses the ticker data data to append the
		 * news featured news title and excerpt.
		 *
		 * @param ticker_data
		 */
		function daextlnl_refresh_featured_news(ticker_data){

			const single_featured_news = ticker_data.featured_news;

			const news_title   = typeof single_featured_news.newstitle !== 'undefined' ? single_featured_news.newstitle : '';
			const news_excerpt = typeof single_featured_news.newsexcerpt !== 'undefined' ? single_featured_news.newsexcerpt : '';
			const url          = typeof single_featured_news.url !== 'undefined' ? single_featured_news.url : '';

			// Delete the featured title.
			$( '#daextlnl-featured-title' ).html( "" );

			// Delete the featured excerpt.
			$( '#daextlnl-featured-excerpt' ).html( "" );

			if ( typeof url !== 'undefined' && url.length > 0 && daextlnl_enable_links ) {

				// Append the new featured title.
				$( '#daextlnl-featured-title' ).html( '<a target="' + daextlnl_target_attribute + '" href="' + url + '">' + daextlnl_htmlEscape( news_title ) + '</a>' );

				// Append the new featured excerpt.
				$( '#daextlnl-featured-excerpt' ).html( daextlnl_htmlEscape( news_excerpt ) );

			} else {

				// Append the new featured title.
				$( '#daextlnl-featured-title' ).html( daextlnl_htmlEscape( news_title ) );

				// Append the new featured excerpt.
				$( '#daextlnl-featured-excerpt' ).html( daextlnl_htmlEscape( news_excerpt ) );

			}

		}

		/**
		 * Deletes all the sliding news from the DOM and uses the ticker data to append the news sliding news.
		 *
		 * @param ticker_data
		 */
		function daextlnl_refresh_sliding_news(ticker_data){

			// Delete the previous sliding news.
			$( '#daextlnl-slider-floating-content' ).empty();

			// Iterate over the sliding news.
			ticker_data.sliding_news.forEach(
				function (single_sliding_news) {

					const news_title               = single_sliding_news.newstitle;
					const url                      = single_sliding_news.url;
					const text_color               = single_sliding_news.text_color;
					const text_color_hover         = single_sliding_news.text_color_hover;
					const background_color         = single_sliding_news.background_color;
					const background_color_opacity = single_sliding_news.background_color_opacity;
					const image_before             = single_sliding_news.image_before;
					const image_after              = single_sliding_news.image_after;
					let style_text_color           = null;
					let style_background_color     = null
					let image_before_html          = null;
					let image_after_html           = null;

					// Generate the style for the text color.
					if ( typeof text_color !== 'undefined' && text_color.trim().length > 0 ) {
						style_text_color = 'style="color: ' + text_color + ';"';
					} else {
						style_text_color = '';
					}

					// Generate the style for the background color.
					if ( typeof background_color !== 'undefined' && background_color.trim().length > 0 ) {
						const color_a          = rgb_hex_to_dec( background_color );
						style_background_color = 'style="background: rgba(' + color_a['r'] + ',' + color_a['g'] + ',' + color_a['b'] + ',' + parseFloat( background_color_opacity ) + ');"';
					} else {
						style_background_color = '';
					}

					// Generate the image_before html.
					if (typeof image_before !== 'undefined' && image_before.trim().length > 0) {
						image_before_html = '<img class="daextlnl-image-before" src="' + image_before + '">';
					} else {
						image_before_html = '';
					}

					// Generate the image_after html.
					if (typeof image_after !== 'undefined' && image_after.trim().length > 0) {
						image_after_html = '<img class="daextlnl-image-after" src="' + image_after + '">';
					} else {
						image_after_html = '';
					}

					// Check if is set the RTL layout option.
					if ( daextlnl_rtl_layout === 0 ) {

						// LTR layout ---------------------------------------------------------------------------------.
						if ( url.length > 0 && daextlnl_enable_links ) {
							$( '#daextlnl-slider-floating-content' ).append( '<div ' + style_background_color + ' class="daextlnl-slider-single-news">' + image_before_html + '<a data-text-color="' + text_color + '" onmouseout=\'jQuery(this).css("color", jQuery(this).attr("data-text-color"))\' onmouseover=\'jQuery(this).css("color", "' + text_color_hover + '" )\' ' + style_text_color + ' target="' + daextlnl_target_attribute + '" href="' + url + '">' + daextlnl_htmlEscape( news_title ) + '</a>' + image_after_html + '</div>' );
						} else {
							$( '#daextlnl-slider-floating-content' ).append( '<div ' + style_background_color + ' class="daextlnl-slider-single-news">' + image_before_html + '<span ' + style_text_color + ' >' + daextlnl_htmlEscape( news_title ) + '</span>' + image_after_html + '</div>' );
						}

					} else {

						// RTL layout ---------------------------------------------------------------------------------.
						if ( url.length > 0 && daextlnl_enable_links ) {
							$( '#daextlnl-slider-floating-content' ).prepend( '<div ' + style_background_color + ' class="daextlnl-slider-single-news">' + image_before_html + '<a  data-text-color="' + text_color + '" onmouseout=\'jQuery(this).css("color", jQuery(this).attr("data-text-color"))\' onmouseover=\'jQuery(this).css("color", "' + text_color_hover + '" )\' ' + style_text_color + ' target="' + daextlnl_target_attribute + '" href="' + url + '">' + daextlnl_htmlEscape( news_title ) + '</a>' + image_after_html + '</div>' );
						} else {
							$( '#daextlnl-slider-floating-content' ).prepend( '<div ' + style_background_color + ' class="daextlnl-slider-single-news">' + image_before_html + '<span ' + style_text_color + ' >' + daextlnl_htmlEscape( news_title ) + '</span>' + image_after_html + '</div>' );
						}

					}
				}
			);

		}

		/**
		 * Slides the news with jQuery animate from the initial to the final position. When the animation is complete calls
		 * daextlnl_refresh_news() which restarts the process from the start.
		 */
		function daextlnl_slide_the_news(){

			// If the news slider is already animated then return.
			if ( ( $( '#daextlnl-slider-floating-content:animated' ).length ) == 1 ) {
				return; };

			// Get browser width.
			const window_width = $( window ).width();

			// Floating news width.
			const floating_news_width = parseInt( $( "#daextlnl-slider-floating-content" ).css( "width" ) );

			// Check if is set the RTL layout option.
			if ( daextlnl_rtl_layout == 0 ) {

				// LTR layout -----------------------------------------------------------------------------------------.

				// Position outside the screen to the left.
				const outside_left = floating_news_width + window_width;

				// Set floating content left position outside the screen.
				$( "#daextlnl-slider-floating-content" ).css( "left", window_width );

				// Start floating the news.
				$( "#daextlnl-slider-floating-content" ).animate(
					{
						left: "-=" + outside_left,
						easing: "linear"
					},
					( outside_left * 10 ),
					"linear",
					function () {

						// Animation complete.
						daextlnl_refresh_news();

					}
				);

			} else {

				// RTL layout -----------------------------------------------------------------------------------------.

				// Position outside the screen to the left.
				const outside_left = floating_news_width + window_width;

				// Set floating content left position outside the screen.
				$( "#daextlnl-slider-floating-content" ).css( "left", - floating_news_width );

				// Start floating the news.
				$( "#daextlnl-slider-floating-content" ).animate(
					{
						left: "+=" + outside_left,
						easing: "linear"
					},
					( outside_left * 10 ),
					"linear",
					function () {

						// Animation complete.
						daextlnl_refresh_news();

					}
				);

			}

		}

		/**
		 * On the click event of the "#daextlnl-close" element closes the news ticker and sends an ajax request used to save
		 * the "closed" status in the "live_news_status" cookie
		 */
		$( "#daextlnl-close" ).click(
			function () {

				// Stop the animation.
				$( "#daextlnl-slider-floating-content" ).stop();

				// Delete the previous sliding news.
				$( '#daextlnl-slider-floating-content' ).empty();

				// Hide the news container.
				$( "#daextlnl-container" ).hide();

				// Show the open button.
				$( "#daextlnl-open" ).show();

				// Prepare input for the ajax request.
				const data = {
					"action": "set_status_cookie",
					"security": window.DAEXTLNL_PARAMETERS.nonce,
					"status": "closed"
				};

				// Ajax.
				$.post(
					window.DAEXTLNL_PARAMETERS.ajaxUrl,
					data,
					function (ajax_response) {

						if ( ajax_response == "success" ) {
							// nothing
						}

					}
				);

				// Set the status hidden field to closed.
				$( "#daextlnl-status" ).attr( "value","closed" );

			}
		);

		/**
		 * On the click event of the "#daextlnl-open" element opens the news ticker and sends an ajax request used to save
		 * the "open" status in the "live_news_status" cookie
		 */
		$( "#daextlnl-open" ).click(
			function () {

				// Show the news container.
				$( "#daextlnl-container" ).show();

				// Show the open button.
				$( "#daextlnl-open" ).hide();

				daextlnl_refresh_news();

				// Prepare input for the ajax request.
				const data = {
					"action": "set_status_cookie",
					"security": window.DAEXTLNL_PARAMETERS.nonce,
					"status": "open"
				};

				// Ajax.
				$.post(
					window.DAEXTLNL_PARAMETERS.ajaxUrl,
					data,
					function (ajax_response) {

						if ( ajax_response == "success" ) {
							// nothing
						}

					}
				);

				// Set the status hidden field to open.
				$( "#daextlnl-status" ).attr( "value","open" );

			}
		);

		/**
		 * Converts certain characters to their HTML entities.
		 *
		 * @param str
		 * @returns {*}
		 */
		function daextlnl_htmlEscape(str) {
			return String( str )
			.replace( /&/g, '&amp;' )
			.replace( /"/g, '&quot;' )
			.replace( /'/g, '&#39;' )
			.replace( /</g, '&lt;' )
			.replace( />/g, '&gt;' );
		}

		/**
		 * Appends the ticker HTML just before the ending body element.
		 */
		function daextlnl_append_html(){

			html_output = '<div id="daextlnl-container">' +

			'<!-- featured news -->' +
			'<div id="daextlnl-featured-container">' +
				'<div id="daextlnl-featured-title-container">' +
					'<div id="daextlnl-featured-title"></div>' +
				'</div>' +
				'<div id="daextlnl-featured-excerpt-container">' +
					'<div id="daextlnl-featured-excerpt"></div>' +
				'</div>' +
			'</div>' +

			'<!-- slider -->' +
			'<div id="daextlnl-slider">' +
				'<!-- floating content -->' +
				'<div id="daextlnl-slider-floating-content"></div>' +
			'</div>' +

			'<!-- clock -->' +
			'<div id="daextlnl-clock"></div>' +

			'<!-- close button -->' +
			'<div id="daextlnl-close"></div>' +

			'</div>' +

			'<!-- open button -->' +
			'<div id="daextlnl-open"></div>';

			$( 'body' ).append( html_output );

		}

		/**
		 * Uses a "Date" object to retrieve the user time and adds the clock offset of this news ticker.
		 */
		function daextlnl_set_clock_based_on_user_time(){

			// Get the current unix timestamp and add the offset.
			const timestamp = moment().unix() + daextlnl_clock_offset;

			// Convert the unix timestamp to the provided format.
			const time = moment.unix( timestamp ).format( daextlnl_clock_format );

			// Update the DOM.
			$( "#daextlnl-clock" ).text( time );

		}

		/**
		 * Given a hexadecimal rgb color an array with the 3 components converted in decimal is returned
		 *
		 * @param string The hexadecimal rgb color
		 * @return array An array with the 3 component of the color converted in decimal
		 */
		function rgb_hex_to_dec(hex){

			let r = null;
			let g = null;
			let b = null;

			// Remove the # character.
			hex = hex.replace( '#', '' );

			// Find the components of the color.
			if ( hex.length == 3 ) {
				r = parseInt( hex.substring( 0, 1 ), 16 );
				g = parseInt( hex.substring( 1, 2 ), 16 );
				b = parseInt( hex.substring( 2, 3 ), 16 );
			} else {
				r = parseInt( hex.substring( 0, 2 ), 16 );
				g = parseInt( hex.substring( 2, 4 ), 16 );
				b = parseInt( hex.substring( 4, 6 ), 16 );
			}

			// Generate the array with the components of the color.
			const color_a = new Array();
			color_a['r']  = r;
			color_a['g']  = g;
			color_a['b']  = b;

			return color_a;

		}

	}
);
// source --> https://wp.raymoon.com.sa/wp-content/plugins/elementor/assets/lib/font-awesome/js/v4-shims.min.js?ver=3.26.3 
/*!
 * Font Awesome Free 5.15.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 */
(function(){var l,a;l=this,a=function(){"use strict";var l={},a={};try{"undefined"!=typeof window&&(l=window),"undefined"!=typeof document&&(a=document)}catch(l){}var e=(l.navigator||{}).userAgent,r=void 0===e?"":e,n=l,o=a,u=(n.document,!!o.documentElement&&!!o.head&&"function"==typeof o.addEventListener&&o.createElement,~r.indexOf("MSIE")||r.indexOf("Trident/"),"___FONT_AWESOME___"),t=function(){try{return"production"===process.env.NODE_ENV}catch(l){return!1}}();var f=n||{};f[u]||(f[u]={}),f[u].styles||(f[u].styles={}),f[u].hooks||(f[u].hooks={}),f[u].shims||(f[u].shims=[]);var i=f[u],s=[["glass",null,"glass-martini"],["meetup","fab",null],["star-o","far","star"],["remove",null,"times"],["close",null,"times"],["gear",null,"cog"],["trash-o","far","trash-alt"],["file-o","far","file"],["clock-o","far","clock"],["arrow-circle-o-down","far","arrow-alt-circle-down"],["arrow-circle-o-up","far","arrow-alt-circle-up"],["play-circle-o","far","play-circle"],["repeat",null,"redo"],["rotate-right",null,"redo"],["refresh",null,"sync"],["list-alt","far",null],["dedent",null,"outdent"],["video-camera",null,"video"],["picture-o","far","image"],["photo","far","image"],["image","far","image"],["pencil",null,"pencil-alt"],["map-marker",null,"map-marker-alt"],["pencil-square-o","far","edit"],["share-square-o","far","share-square"],["check-square-o","far","check-square"],["arrows",null,"arrows-alt"],["times-circle-o","far","times-circle"],["check-circle-o","far","check-circle"],["mail-forward",null,"share"],["expand",null,"expand-alt"],["compress",null,"compress-alt"],["eye","far",null],["eye-slash","far",null],["warning",null,"exclamation-triangle"],["calendar",null,"calendar-alt"],["arrows-v",null,"arrows-alt-v"],["arrows-h",null,"arrows-alt-h"],["bar-chart","far","chart-bar"],["bar-chart-o","far","chart-bar"],["twitter-square","fab",null],["facebook-square","fab",null],["gears",null,"cogs"],["thumbs-o-up","far","thumbs-up"],["thumbs-o-down","far","thumbs-down"],["heart-o","far","heart"],["sign-out",null,"sign-out-alt"],["linkedin-square","fab","linkedin"],["thumb-tack",null,"thumbtack"],["external-link",null,"external-link-alt"],["sign-in",null,"sign-in-alt"],["github-square","fab",null],["lemon-o","far","lemon"],["square-o","far","square"],["bookmark-o","far","bookmark"],["twitter","fab",null],["facebook","fab","facebook-f"],["facebook-f","fab","facebook-f"],["github","fab",null],["credit-card","far",null],["feed",null,"rss"],["hdd-o","far","hdd"],["hand-o-right","far","hand-point-right"],["hand-o-left","far","hand-point-left"],["hand-o-up","far","hand-point-up"],["hand-o-down","far","hand-point-down"],["arrows-alt",null,"expand-arrows-alt"],["group",null,"users"],["chain",null,"link"],["scissors",null,"cut"],["files-o","far","copy"],["floppy-o","far","save"],["navicon",null,"bars"],["reorder",null,"bars"],["pinterest","fab",null],["pinterest-square","fab",null],["google-plus-square","fab",null],["google-plus","fab","google-plus-g"],["money","far","money-bill-alt"],["unsorted",null,"sort"],["sort-desc",null,"sort-down"],["sort-asc",null,"sort-up"],["linkedin","fab","linkedin-in"],["rotate-left",null,"undo"],["legal",null,"gavel"],["tachometer",null,"tachometer-alt"],["dashboard",null,"tachometer-alt"],["comment-o","far","comment"],["comments-o","far","comments"],["flash",null,"bolt"],["clipboard","far",null],["paste","far","clipboard"],["lightbulb-o","far","lightbulb"],["exchange",null,"exchange-alt"],["cloud-download",null,"cloud-download-alt"],["cloud-upload",null,"cloud-upload-alt"],["bell-o","far","bell"],["cutlery",null,"utensils"],["file-text-o","far","file-alt"],["building-o","far","building"],["hospital-o","far","hospital"],["tablet",null,"tablet-alt"],["mobile",null,"mobile-alt"],["mobile-phone",null,"mobile-alt"],["circle-o","far","circle"],["mail-reply",null,"reply"],["github-alt","fab",null],["folder-o","far","folder"],["folder-open-o","far","folder-open"],["smile-o","far","smile"],["frown-o","far","frown"],["meh-o","far","meh"],["keyboard-o","far","keyboard"],["flag-o","far","flag"],["mail-reply-all",null,"reply-all"],["star-half-o","far","star-half"],["star-half-empty","far","star-half"],["star-half-full","far","star-half"],["code-fork",null,"code-branch"],["chain-broken",null,"unlink"],["shield",null,"shield-alt"],["calendar-o","far","calendar"],["maxcdn","fab",null],["html5","fab",null],["css3","fab",null],["ticket",null,"ticket-alt"],["minus-square-o","far","minus-square"],["level-up",null,"level-up-alt"],["level-down",null,"level-down-alt"],["pencil-square",null,"pen-square"],["external-link-square",null,"external-link-square-alt"],["compass","far",null],["caret-square-o-down","far","caret-square-down"],["toggle-down","far","caret-square-down"],["caret-square-o-up","far","caret-square-up"],["toggle-up","far","caret-square-up"],["caret-square-o-right","far","caret-square-right"],["toggle-right","far","caret-square-right"],["eur",null,"euro-sign"],["euro",null,"euro-sign"],["gbp",null,"pound-sign"],["usd",null,"dollar-sign"],["dollar",null,"dollar-sign"],["inr",null,"rupee-sign"],["rupee",null,"rupee-sign"],["jpy",null,"yen-sign"],["cny",null,"yen-sign"],["rmb",null,"yen-sign"],["yen",null,"yen-sign"],["rub",null,"ruble-sign"],["ruble",null,"ruble-sign"],["rouble",null,"ruble-sign"],["krw",null,"won-sign"],["won",null,"won-sign"],["btc","fab",null],["bitcoin","fab","btc"],["file-text",null,"file-alt"],["sort-alpha-asc",null,"sort-alpha-down"],["sort-alpha-desc",null,"sort-alpha-down-alt"],["sort-amount-asc",null,"sort-amount-down"],["sort-amount-desc",null,"sort-amount-down-alt"],["sort-numeric-asc",null,"sort-numeric-down"],["sort-numeric-desc",null,"sort-numeric-down-alt"],["youtube-square","fab",null],["youtube","fab",null],["xing","fab",null],["xing-square","fab",null],["youtube-play","fab","youtube"],["dropbox","fab",null],["stack-overflow","fab",null],["instagram","fab",null],["flickr","fab",null],["adn","fab",null],["bitbucket","fab",null],["bitbucket-square","fab","bitbucket"],["tumblr","fab",null],["tumblr-square","fab",null],["long-arrow-down",null,"long-arrow-alt-down"],["long-arrow-up",null,"long-arrow-alt-up"],["long-arrow-left",null,"long-arrow-alt-left"],["long-arrow-right",null,"long-arrow-alt-right"],["apple","fab",null],["windows","fab",null],["android","fab",null],["linux","fab",null],["dribbble","fab",null],["skype","fab",null],["foursquare","fab",null],["trello","fab",null],["gratipay","fab",null],["gittip","fab","gratipay"],["sun-o","far","sun"],["moon-o","far","moon"],["vk","fab",null],["weibo","fab",null],["renren","fab",null],["pagelines","fab",null],["stack-exchange","fab",null],["arrow-circle-o-right","far","arrow-alt-circle-right"],["arrow-circle-o-left","far","arrow-alt-circle-left"],["caret-square-o-left","far","caret-square-left"],["toggle-left","far","caret-square-left"],["dot-circle-o","far","dot-circle"],["vimeo-square","fab",null],["try",null,"lira-sign"],["turkish-lira",null,"lira-sign"],["plus-square-o","far","plus-square"],["slack","fab",null],["wordpress","fab",null],["openid","fab",null],["institution",null,"university"],["bank",null,"university"],["mortar-board",null,"graduation-cap"],["yahoo","fab",null],["google","fab",null],["reddit","fab",null],["reddit-square","fab",null],["stumbleupon-circle","fab",null],["stumbleupon","fab",null],["delicious","fab",null],["digg","fab",null],["pied-piper-pp","fab",null],["pied-piper-alt","fab",null],["drupal","fab",null],["joomla","fab",null],["spoon",null,"utensil-spoon"],["behance","fab",null],["behance-square","fab",null],["steam","fab",null],["steam-square","fab",null],["automobile",null,"car"],["envelope-o","far","envelope"],["spotify","fab",null],["deviantart","fab",null],["soundcloud","fab",null],["file-pdf-o","far","file-pdf"],["file-word-o","far","file-word"],["file-excel-o","far","file-excel"],["file-powerpoint-o","far","file-powerpoint"],["file-image-o","far","file-image"],["file-photo-o","far","file-image"],["file-picture-o","far","file-image"],["file-archive-o","far","file-archive"],["file-zip-o","far","file-archive"],["file-audio-o","far","file-audio"],["file-sound-o","far","file-audio"],["file-video-o","far","file-video"],["file-movie-o","far","file-video"],["file-code-o","far","file-code"],["vine","fab",null],["codepen","fab",null],["jsfiddle","fab",null],["life-ring","far",null],["life-bouy","far","life-ring"],["life-buoy","far","life-ring"],["life-saver","far","life-ring"],["support","far","life-ring"],["circle-o-notch",null,"circle-notch"],["rebel","fab",null],["ra","fab","rebel"],["resistance","fab","rebel"],["empire","fab",null],["ge","fab","empire"],["git-square","fab",null],["git","fab",null],["hacker-news","fab",null],["y-combinator-square","fab","hacker-news"],["yc-square","fab","hacker-news"],["tencent-weibo","fab",null],["qq","fab",null],["weixin","fab",null],["wechat","fab","weixin"],["send",null,"paper-plane"],["paper-plane-o","far","paper-plane"],["send-o","far","paper-plane"],["circle-thin","far","circle"],["header",null,"heading"],["sliders",null,"sliders-h"],["futbol-o","far","futbol"],["soccer-ball-o","far","futbol"],["slideshare","fab",null],["twitch","fab",null],["yelp","fab",null],["newspaper-o","far","newspaper"],["paypal","fab",null],["google-wallet","fab",null],["cc-visa","fab",null],["cc-mastercard","fab",null],["cc-discover","fab",null],["cc-amex","fab",null],["cc-paypal","fab",null],["cc-stripe","fab",null],["bell-slash-o","far","bell-slash"],["trash",null,"trash-alt"],["copyright","far",null],["eyedropper",null,"eye-dropper"],["area-chart",null,"chart-area"],["pie-chart",null,"chart-pie"],["line-chart",null,"chart-line"],["lastfm","fab",null],["lastfm-square","fab",null],["ioxhost","fab",null],["angellist","fab",null],["cc","far","closed-captioning"],["ils",null,"shekel-sign"],["shekel",null,"shekel-sign"],["sheqel",null,"shekel-sign"],["meanpath","fab","font-awesome"],["buysellads","fab",null],["connectdevelop","fab",null],["dashcube","fab",null],["forumbee","fab",null],["leanpub","fab",null],["sellsy","fab",null],["shirtsinbulk","fab",null],["simplybuilt","fab",null],["skyatlas","fab",null],["diamond","far","gem"],["intersex",null,"transgender"],["facebook-official","fab","facebook"],["pinterest-p","fab",null],["whatsapp","fab",null],["hotel",null,"bed"],["viacoin","fab",null],["medium","fab",null],["y-combinator","fab",null],["yc","fab","y-combinator"],["optin-monster","fab",null],["opencart","fab",null],["expeditedssl","fab",null],["battery-4",null,"battery-full"],["battery",null,"battery-full"],["battery-3",null,"battery-three-quarters"],["battery-2",null,"battery-half"],["battery-1",null,"battery-quarter"],["battery-0",null,"battery-empty"],["object-group","far",null],["object-ungroup","far",null],["sticky-note-o","far","sticky-note"],["cc-jcb","fab",null],["cc-diners-club","fab",null],["clone","far",null],["hourglass-o","far","hourglass"],["hourglass-1",null,"hourglass-start"],["hourglass-2",null,"hourglass-half"],["hourglass-3",null,"hourglass-end"],["hand-rock-o","far","hand-rock"],["hand-grab-o","far","hand-rock"],["hand-paper-o","far","hand-paper"],["hand-stop-o","far","hand-paper"],["hand-scissors-o","far","hand-scissors"],["hand-lizard-o","far","hand-lizard"],["hand-spock-o","far","hand-spock"],["hand-pointer-o","far","hand-pointer"],["hand-peace-o","far","hand-peace"],["registered","far",null],["creative-commons","fab",null],["gg","fab",null],["gg-circle","fab",null],["tripadvisor","fab",null],["odnoklassniki","fab",null],["odnoklassniki-square","fab",null],["get-pocket","fab",null],["wikipedia-w","fab",null],["safari","fab",null],["chrome","fab",null],["firefox","fab",null],["opera","fab",null],["internet-explorer","fab",null],["television",null,"tv"],["contao","fab",null],["500px","fab",null],["amazon","fab",null],["calendar-plus-o","far","calendar-plus"],["calendar-minus-o","far","calendar-minus"],["calendar-times-o","far","calendar-times"],["calendar-check-o","far","calendar-check"],["map-o","far","map"],["commenting",null,"comment-dots"],["commenting-o","far","comment-dots"],["houzz","fab",null],["vimeo","fab","vimeo-v"],["black-tie","fab",null],["fonticons","fab",null],["reddit-alien","fab",null],["edge","fab",null],["credit-card-alt",null,"credit-card"],["codiepie","fab",null],["modx","fab",null],["fort-awesome","fab",null],["usb","fab",null],["product-hunt","fab",null],["mixcloud","fab",null],["scribd","fab",null],["pause-circle-o","far","pause-circle"],["stop-circle-o","far","stop-circle"],["bluetooth","fab",null],["bluetooth-b","fab",null],["gitlab","fab",null],["wpbeginner","fab",null],["wpforms","fab",null],["envira","fab",null],["wheelchair-alt","fab","accessible-icon"],["question-circle-o","far","question-circle"],["volume-control-phone",null,"phone-volume"],["asl-interpreting",null,"american-sign-language-interpreting"],["deafness",null,"deaf"],["hard-of-hearing",null,"deaf"],["glide","fab",null],["glide-g","fab",null],["signing",null,"sign-language"],["viadeo","fab",null],["viadeo-square","fab",null],["snapchat","fab",null],["snapchat-ghost","fab",null],["snapchat-square","fab",null],["pied-piper","fab",null],["first-order","fab",null],["yoast","fab",null],["themeisle","fab",null],["google-plus-official","fab","google-plus"],["google-plus-circle","fab","google-plus"],["font-awesome","fab",null],["fa","fab","font-awesome"],["handshake-o","far","handshake"],["envelope-open-o","far","envelope-open"],["linode","fab",null],["address-book-o","far","address-book"],["vcard",null,"address-card"],["address-card-o","far","address-card"],["vcard-o","far","address-card"],["user-circle-o","far","user-circle"],["user-o","far","user"],["id-badge","far",null],["drivers-license",null,"id-card"],["id-card-o","far","id-card"],["drivers-license-o","far","id-card"],["quora","fab",null],["free-code-camp","fab",null],["telegram","fab",null],["thermometer-4",null,"thermometer-full"],["thermometer",null,"thermometer-full"],["thermometer-3",null,"thermometer-three-quarters"],["thermometer-2",null,"thermometer-half"],["thermometer-1",null,"thermometer-quarter"],["thermometer-0",null,"thermometer-empty"],["bathtub",null,"bath"],["s15",null,"bath"],["window-maximize","far",null],["window-restore","far",null],["times-rectangle",null,"window-close"],["window-close-o","far","window-close"],["times-rectangle-o","far","window-close"],["bandcamp","fab",null],["grav","fab",null],["etsy","fab",null],["imdb","fab",null],["ravelry","fab",null],["eercast","fab","sellcast"],["snowflake-o","far","snowflake"],["superpowers","fab",null],["wpexplorer","fab",null],["cab",null,"taxi"]];return function(l){try{l()}catch(l){if(!t)throw l}}(function(){var l;"function"==typeof i.hooks.addShims?i.hooks.addShims(s):(l=i.shims).push.apply(l,s)}),s},"object"==typeof exports&&"undefined"!=typeof module?module.exports=a():"function"==typeof define&&define.amd?define(a):l["fontawesome-free-shims"]=a();})();